' Utility to rewrite a Unicode text file as an ANSI text file
' For use with Windows Scripting Host, CScript.exe or WScript.exe
' Copyright (c) Microsoft Corporation. All rights reserved.
'
Option Explicit

' FileSystemObject.CreateTextFile and FileSystemObject.OpenTextFile
Const OpenAsASCII   = 0 
Const OpenAsUnicode = -1

' FileSystemObject.CreateTextFile
Const OverwriteIfExist = -1
Const FailIfExist      = 0

' FileSystemObject.OpenTextFile
Const OpenAsDefault    = -2
Const CreateIfNotExist = -1
Const FailIfNotExist   = 0
Const ForReading = 1
Const ForWriting = 2
Const ForAppending = 8

Dim argCount:argCount = Wscript.Arguments.Count
If argCount > 0 Then If InStr(1, Wscript.Arguments(0), "?", vbTextCompare) > 0 Then argCount = 0
If (argCount = 0) Then
	Wscript.Echo "Utility to copy Unicode text file to an ANSI text file." &_
		vbNewLine & "The 1st argument is the Unicode text file to read" &_
		vbNewLine & "The 2nd argument is the ANSI text file to write" &_
		vbNewLine & "If the 2nd argument is omitted, the Unicode file will be replaced" &_
		vbNewLine &_
		vbNewLine & "Copyright (C) Microsoft Corporation.  All rights reserved."
	Wscript.Quit 1
End If

Dim inFile, outFile, inStream, outStream, inLine, FileSys, WshShell
If argCount > 1 Then
	outFile = Wscript.Arguments(1)
	inFile  = Wscript.Arguments(0)
Else
	outFile = Wscript.Arguments(0)
	inFile  = outFile & ".tmp"
	Set WshShell = Wscript.CreateObject("Wscript.Shell")
	WshShell.Run "cmd.exe /c copy " & outFile & " " & inFile, 0, True
End If

Set FileSys = CreateObject("Scripting.FileSystemObject")
Set inStream  = FileSys.OpenTextFile(inFile, ForReading, FailIfNotExist, OpenAsDefault)
Set outStream = FileSys.CreateTextFile(outFile, OverwriteIfExist, OpenAsASCII)
Do
	inLine = inStream.ReadLine
	outStream.WriteLine inLine
Loop Until inStream.AtEndOfStream
inStream.Close
outStream.Close
If argCount = 1 Then WshShell.Run "cmd.exe /c del " & inFile, 0
